import { useMemo, useCallback, useEffect } from 'react';
import { EventWidgetWithApiService } from '../EventWidget.service';

interface widgetApiServiceProps {
  providerUrl: string;
  date?: string;
}

export const useWidgetApiService = (props: widgetApiServiceProps) => {
  const { providerUrl, date } = props;

  const EventWidgetService = useMemo(() => new EventWidgetWithApiService(), []);

  useEffect(() => {
    if (providerUrl) {
      EventWidgetService.setUrl(providerUrl);
      EventWidgetService.setDate(date ? new Date(date) : new Date());
      EventWidgetService.load();
    }
  }, [providerUrl, date]);

  const onNavigate = useCallback((date) => {
    EventWidgetService.setDate(date);
    EventWidgetService.load();
  }, []);

  return {
    date: EventWidgetService.date,
    participants: EventWidgetService.participants,
    onNavigate,
  };
};
