import React from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import Button from '@crm/components/dist/lego2/Button';
import { ExpandButtonProps } from './ExpandButton.types';
import css from './ExpandButton.module.css';

export const ExpandButton: React.FC<ExpandButtonProps> = ({
  className,
  text,
  expanded,
  ...props
}) => {
  return (
    <Button
      className={cx(css.ExpandButton, className, {
        [css.ExpandButton_expanded]: expanded,
      })}
      {...props}
    >
      <span data-testid="ExpandButtonText" className={css.ExpandButton__text}>
        {text}
      </span>
      <Icon
        aria-expanded={expanded}
        className={css.ExpandButton__icon}
        svgSize="s"
        svg="chevron2"
        svgUseSelfWidth
      />
    </Button>
  );
};
