import React, { useMemo, useState } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './ExpandText.module.css';
import { ExpandTextProps } from './ExpandText.types';

export const ExpandText: React.FC<ExpandTextProps> = ({ className, text, maxSymbols = 100 }) => {
  const { value = '', bold, color = 'primary' } = text;
  const [isExpanded, setExpanded] = useState(false);

  const isClamped = value.length > maxSymbols;

  const toggleExpanded = () => setExpanded((expanded) => !expanded);

  const clampedValue = useMemo(() => {
    return value.slice(0, maxSymbols);
  }, [value, maxSymbols]);

  return (
    <>
      <Text
        color={color}
        typography="body-short-m"
        className={className}
        weight={bold ? 'bold' : 'regular'}
        data-testid="clamped-text"
      >
        {isExpanded ? value : clampedValue}
      </Text>
      {isClamped && (
        <span onClick={toggleExpanded} data-testid="expand-more">
          <Text
            weight="bold"
            typography="body-short-m"
            color="ghost"
            className={css.Text__expandMore}
          >
            {isExpanded ? ' Скрыть' : '... Раскрыть'}
          </Text>
        </span>
      )}
    </>
  );
};
