import React, { FC } from 'react';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import { ExpandWidgetProps } from './ExpandWidget.types';
import css from './ExpandWidget.module.css';

export const ExpandWidget: FC<ExpandWidgetProps> = (props) => {
  const { text, onClick, tone = 'blue' } = props;

  const className = cx(css.ExpandWidget, css[`ExpandWidget_color_${tone}`], props.className);
  const view = tone === 'blue' ? 'action' : 'default';

  return (
    <div className={className}>
      <div className={css.ExpandWidget__text}>{text}</div>
      <Button className={css.ExpandWidget__button} view={view} onClick={onClick}>
        Развернуть
      </Button>
    </div>
  );
};
