import React from 'react';
import PropTypes from 'prop-types';

const sp = (e) => { e.stopPropagation(); };

const URL_REGEX = /^((?:http|https|ftp):\/\/)?((?:[\w-]+)(?:\.[\w-]+)+)(?:[\w.,@?^=%&amp;:/~+#-]*[\w@?^=%&amp;/~+#-])?$/;

const ExternalLink = (props) => {
  const { value, stopPropagation } = props;

  if (typeof value === 'string' && value) {
    if (URL_REGEX.test(value)) {
      const hasProtocol = value.search(/:\/\//) !== -1;

      let link;
      if (!hasProtocol) {
        link = `//${value}`;
      } else {
        link = value;
      }

      const extraProps = {};
      if (stopPropagation) {
        extraProps.onClick = sp;
      }

      return (
        <a
          href={link}
          target="_blank"
          rel="noopener noreferrer"
          {...extraProps}
        >
          {value}
        </a>
      );
    }

    return <span>{value}</span>;
  }

  return null;
};

ExternalLink.propTypes = {
  value: PropTypes.string,
  stopPropagation: PropTypes.bool,
};

ExternalLink.defaultProps = {
  value: undefined,
  stopPropagation: false,
};

export default ExternalLink;
