import React from 'react';
import PropTypes from 'prop-types';
import ExternalLink from './ExternalLink';

const ExternalLinks = (props) => {
  const { value, stopPropagation } = props;

  if (typeof value === 'string' && value) {
    const result = [];
    value
      .split(/,|;/)
      .forEach((link) => {
        const trimLink = link.trim();
        if (trimLink) {
          if (result.length > 0) {
            result.push(<span key={`${trimLink}_seperator`}>,&nbsp;</span>);
          }
          result.push((
            <ExternalLink
              key={trimLink}
              value={trimLink}
              stopPropagation={stopPropagation}
            />
          ));
        }
      });

    if (result.length) {
      return <span>{result}</span>;
    }
  }

  return null;
};

ExternalLinks.propTypes = {
  value: PropTypes.string,
  stopPropagation: PropTypes.bool,
};

ExternalLinks.defaultProps = {
  value: undefined,
  stopPropagation: false,
};

export default ExternalLinks;
