import React, { FC } from 'react';
import cx from 'classnames';
import { ControlsProps } from './Controls.types';
import SlideButton from '../buttons/SlideButton';
import css from './Controls.module.css';

const Controls: FC<ControlsProps> = (props) => {
  const { canSlideLeft, canSlideRight, slideToLeft, slideToRight } = props;

  return (
    <div className={css.Controls}>
      <SlideButton
        direction="left"
        disabled={!canSlideLeft}
        onClick={slideToLeft}
        className={cx(css.Controls__slideButton, css.Controls__slideButton_left)}
      />
      <SlideButton
        direction="right"
        disabled={!canSlideRight}
        onClick={slideToRight}
        className={cx(css.Controls__slideButton, css.Controls__slideButton_right)}
      />
    </div>
  );
};

export default Controls;
