import React, { FC } from 'react';
import cx from 'classnames';
import { FileProps } from './types';
import { DocviewerFileProps } from './DocviewerFile.types';

const DocviewerFile: FC<FileProps & DocviewerFileProps> = (props) => {
  const { onLoad, onError, style, src, title } = props;

  const className = cx('File', 'File_type_docviewer', props.className);

  return (
    <iframe
      onLoad={onLoad}
      onError={onError}
      className={className}
      style={style}
      src={src}
      title={title}
    />
  );
};

export default DocviewerFile;
