import React, { FC } from 'react';
import { FileType } from '../types';
import ImageFile from './ImageFile';
import DocviewerFile from './DocviewerFile';
import NullFile from './NullFile';
import { FileFactoryProps } from './types';

const FileFactory: FC<FileFactoryProps> = (props) => {
  const { type, ...fileProps } = props;

  switch (type) {
    case FileType.Image: {
      return <ImageFile {...fileProps} />;
    }

    case FileType.Docviewer: {
      return <DocviewerFile {...fileProps} />;
    }

    default: {
      return <NullFile {...fileProps} />;
    }
  }
};

export default FileFactory;
