import React, { FC } from 'react';
import cx from 'classnames';
import { FileProps } from './types';
import { ImageFileProps } from './ImageFile.types';

const ImageFile: FC<FileProps & ImageFileProps> = (props) => {
  const { onLoad, onError, onMouseDown, style, src, alt } = props;

  const className = cx('File', 'File_type_image', props.className);

  return (
    <img
      role="presentation"
      onLoad={onLoad}
      onError={onError}
      className={className}
      draggable={false}
      onMouseDown={onMouseDown}
      style={style}
      src={src}
      alt={alt}
    />
  );
};

export default ImageFile;
