import { ImageFileProps } from './ImageFile.types';
import { DocviewerFileProps } from './DocviewerFile.types';
import { FileType } from '../types';

export interface FileProps {
  className?: string;
}

export interface NonNullFileProps extends FileProps {
  src: string;
  onLoad?: () => void;
  onError?: () => void;
  style?: React.CSSProperties;
}

export type FileFactoryProps = ImageFileProps &
  DocviewerFileProps & {
    type: FileType;
  };
