import { Slide } from './types';
import { TransformProps } from './withTransformMatrix';

export interface FileViewerConnectedStateProps {
  isFailed: boolean;
  isLoading: boolean;
  visible: boolean;
  slideIndex: number;
  slides: Slide[];
  canSlideLeft: boolean;
  canSlideRight: boolean;
}

export interface FileViewerConnectedDispatchProps {
  showLoader: () => void;
  hideLoader: () => void;
  showError: () => void;
  hideError: () => void;
  slideTo: (slideIndex: number) => void;
  slideToLeft: () => void;
  slideToRight: () => void;
  hide: () => void;
}

export type FileViewerProps = FileViewerConnectedStateProps &
  FileViewerConnectedDispatchProps &
  TransformProps;
