import React, { FC } from 'react';
import cx from 'classnames';
import { HeaderProps } from './Header.types';
import DownloadButton from '../buttons/DownloadButton';
import CrossButton from '../buttons/CrossButton';
import css from './Header.module.css';

const Header: FC<HeaderProps> = (props) => {
  const { slide, children } = props;

  return (
    <header className={css.Header}>
      <div className={cx(css.Header__part, css.Header__part_left)}>
        <DownloadButton className={css.Header__downloadButton} url={slide.downloadUrl} />
        <span className={css.Header__title}>{slide.title}</span>
      </div>

      {children}

      <div className={cx(css.Header__part, css.Header__part_right)}>
        <CrossButton onClick={props.onCross} />
      </div>
    </header>
  );
};

export default Header;
