import React, { FC } from 'react';
import { HeaderFactoryProps } from './HeaderFactory.types';
import { FileType } from '../types';
import Header from './Header';
import ImageHeader from './ImageHeader';

const HeaderFactory: FC<HeaderFactoryProps> = (props) => {
  const { slide } = props;
  switch (slide.type) {
    case FileType.Image: {
      return <ImageHeader {...props} />;
    }

    default: {
      return <Header {...props} />;
    }
  }
};

export default HeaderFactory;
