import React, { FC } from 'react';
import cx from 'classnames';
import Header from './Header';
import { ImageHeaderProps } from './ImageHeader.types';
import { HeaderProps } from './Header.types';
import ZoomInButton from '../buttons/ZoomInButton';
import ZoomOutButton from '../buttons/ZoomOutButton';
import ResetButton from '../buttons/ResetButton';
import RotateLeftButton from '../buttons/RotateLeftButton';
import RotateRightButton from '../buttons/RotateRightButton';
import css from './Header.module.css';

const ImageHeader: FC<HeaderProps & ImageHeaderProps> = (props) => {
  const { slide, onCross } = props;

  return (
    <Header slide={slide} onCross={onCross}>
      <div className={cx(css.Header__part, css.Header__part_center)}>
        <ZoomOutButton className={css.Header__zoomOutButton} onClick={props.onZoomOut} />
        <ZoomInButton className={css.Header__zoomInButton} onClick={props.onZoomIn} />
        <ResetButton className={css.Header__resetButton} onClick={props.onReset} />
        <RotateLeftButton className={css.Header__rotateLeftButton} onClick={props.onRotateLeft} />
        <RotateRightButton
          className={css.Header__rotateRightButton}
          onClick={props.onRotateRight}
        />
      </div>
    </Header>
  );
};

export default ImageHeader;
