import React, { FC } from 'react';
import Spin from '@crm/components/dist/lego2/Spin';
import cx from 'classnames';
import { InnerProps } from './Inner.types';
import { FileFactory } from '../File';
import css from './Inner.module.css';
import './Inner.css';

const Inner: FC<InnerProps> = (props) => {
  const {
    slide,
    isLoading,
    isFailed,
    showError,
    hideLoader,
    transformation,
    onMouseDown,
    onMouseMove,
    onMouseLeave,
    onMouseUp,
    onWheel,
    containerRef,
    appendAddon,
  } = props;

  let file = (
    <FileFactory
      type={slide.type}
      src={slide.url}
      onLoad={hideLoader}
      onError={showError}
      onMouseDown={onMouseDown}
      className="Inner__File"
      style={transformation}
      title={slide.title}
      alt={slide.title}
    />
  );

  if (isFailed) {
    file = <div className={css.Inner__error}>Произошла ошибка, попробуйте еще раз</div>;
  }

  const wrapperClassName = cx(css.Inner__spinWrapper, {
    [css.Inner__spinWrapper_visible]: isLoading && !isFailed,
  });

  return (
    <div
      role="presentation"
      className={css.Inner}
      onWheel={onWheel}
      onMouseMove={onMouseMove}
      onMouseUp={onMouseUp}
      onMouseLeave={onMouseLeave}
      ref={containerRef}
    >
      {file}
      <div className={wrapperClassName}>
        <Spin
          className={css.Inner__spin}
          progress={isLoading && !isFailed}
          size="m"
          position="center"
          view="default"
        />
      </div>
      {appendAddon}
    </div>
  );
};

export default Inner;
