export class Point {
  public x: number;

  public y: number;

  public constructor(x: number, y: number) {
    this.x = x;
    this.y = y;
  }
}

export class Matrix {
  public data: number[][];

  public constructor(matrix: number[][]) {
    this.data = matrix;
  }

  public getScale = (): number => Math.sqrt(this.data[0][0] ** 2 + this.data[0][1] ** 2);

  public multiply = (matrix: Matrix): Matrix => {
    const aNumRows = this.data.length;
    const aNumCols = this.data[0].length;
    const bNumCols = matrix.data[0].length;
    const m = new Array(aNumRows);
    for (let r = 0; r < aNumRows; r += 1) {
      m[r] = new Array(bNumCols);
      for (let c = 0; c < bNumCols; c += 1) {
        m[r][c] = 0;
        for (let i = 0; i < aNumCols; i += 1) {
          m[r][c] += this.data[r][i] * matrix.data[i][c];
        }
      }
    }

    return new Matrix(m);
  };

  /* work corrent only for matrix without rotation and same dimension scale */
  public getInverseMatrix() {
    const scale = this.getScale();

    return new Matrix([
      [1 / scale, 0, -this.data[0][2] / scale],
      [0, 1 / scale, -this.data[1][2] / scale],
      [0, 0, 1],
    ]);
  }
}

export class IdentityMatrix extends Matrix {
  public constructor() {
    super([
      [1, 0, 0],
      [0, 1, 0],
      [0, 0, 1],
    ]);
  }
}

export class TranslateMatrix extends Matrix {
  public constructor(x: number, y: number) {
    super([
      [1, 0, x],
      [0, 1, y],
      [0, 0, 1],
    ]);
  }
}

export class RotateMatrix extends Matrix {
  public constructor(deg: number) {
    const radian = (Math.PI / 180) * deg;
    const cos = Math.round(Math.cos(radian) * 1000) / 1000;
    const sin = Math.round(Math.sin(radian) * 1000) / 1000;

    super([
      [cos, -sin, 0],
      [sin, cos, 0],
      [0, 0, 1],
    ]);
  }
}

export class ScaleMatrix extends Matrix {
  public constructor(multiplier: number) {
    super([
      [multiplier, 0, 0],
      [0, multiplier, 0],
      [0, 0, 1],
    ]);
  }
}

export default Matrix;
