import React, { FC, useCallback } from 'react';
import cx from 'classnames';
import css from './Preview.module.css';
import { PreviewProps } from './Preview.types';

const Preview: FC<PreviewProps> = (props) => {
  const { slide, active, onClick, index } = props;

  const handleClick = useCallback(() => {
    if (onClick && index != null) {
      onClick(index);
    }
  }, [onClick, index]);

  const className = cx(css.Preview, {
    [css.Preview_active]: active,
  });

  return (
    <div className={className} onClick={handleClick} title={slide.title}>
      <span className={css.Preview_text}>{slide.title}</span>
    </div>
  );
};

export default Preview;
