import React, { FC, useCallback } from 'react';
import cx from 'classnames';
import FileViewerButton from '../FileViewerButton';
import { FileViewerButtonProps, FileViewerButtonRender } from '../FileViewerButton.types';
import css from './CrossButton.module.css';

const CrossButton: FC<FileViewerButtonProps> = (props) => {
  const crossRender = useCallback<FileViewerButtonRender>((renderProps) => {
    const className = cx(renderProps.className, css.CrossButton);
    return (
      <button type="button" {...renderProps} className={className}>
        <span className={css.CrossButton__cross}>×</span>
      </button>
    );
  }, []);

  return <FileViewerButton {...props} render={crossRender} />;
};

export default CrossButton;
