import React, { FC, useCallback } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import FileViewerButton from '../FileViewerButton';
import { FileViewerButtonRender } from '../FileViewerButton.types';
import { DownloadButtonProps } from './DownloadButton.types';
import css from './DownloadButton.module.css';

const DownloadButton: FC<DownloadButtonProps> = (props) => {
  const { url } = props;

  const downloadRender = useCallback<FileViewerButtonRender>(
    (renderProps) => {
      const className = cx(renderProps.className, css.DownloadButton);

      return (
        <a download href={url} {...renderProps} className={className}>
          <Icon svg="download" className={css.DownloadButton__icon} />
        </a>
      );
    },
    [url],
  );

  return <FileViewerButton {...props} render={downloadRender} />;
};

export default DownloadButton;
