import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { FileViewerButtonProps, FileViewerButtonRender } from './FileViewerButton.types';
import css from './FileViewerButton.module.css';
import { mapIcon } from './FileViewerButton.utils';

const defaultRender: FileViewerButtonRender = (props) => {
  const { icon, onClick, className } = props;

  return (
    <button type="button" className={className} onClick={onClick}>
      <Icon svg={mapIcon(icon)} className={css.FileViewerButton__icon} />
    </button>
  );
};

const FileViewerButton: FC<FileViewerButtonProps> = (props) => {
  const { render = defaultRender } = props;
  const className = cx(props.className, css.FileViewerButton, {
    [css.FileViewerButton_disabled]: props.disabled,
  });

  return render({
    ...props,
    className,
  });
};

export default FileViewerButton;
