import React, { FC } from 'react';
import cx from 'classnames';
import FileViewerButton from '../FileViewerButton';
import { FileViewerButtonProps, FileViewerButtonIconType } from '../FileViewerButton.types';
import { SlideButtonProps, Direction } from './SlideButton.types';
import css from './SlideButton.module.css';

const getIcon = (direction: Direction): FileViewerButtonIconType => {
  return direction === 'left' ? 'arrowLeft' : 'arrowRight';
};

const SlideButton: FC<FileViewerButtonProps & SlideButtonProps> = (props) => {
  const { direction = 'left' } = props;
  const className = cx(css.SlideButton, props.className, {
    [css.SlideButton_direction_left]: direction === 'left',
    [css.SlideButton_direction_right]: direction === 'right',
  });
  return <FileViewerButton {...props} className={className} icon={getIcon(direction)} />;
};

export default SlideButton;
