/* eslint-disable no-param-reassign */
import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { Slide, SlideDirection } from './types';
import { NAME } from './constants';

interface FileViewerState {
  isFailed: boolean;
  isLoading: boolean;
  isVisible: boolean;
  slideIndex: number;
  slides: Slide[];
}

const initialState: FileViewerState = {
  isFailed: false,
  isLoading: true,
  isVisible: false,
  slideIndex: -1,
  slides: [],
};

const canSlide = (state, direction: SlideDirection): boolean => {
  const index = state.slideIndex;
  const { slides } = state;

  if (index === -1 || index == null || slides == null) {
    return false;
  }

  if (direction === SlideDirection.Left) {
    return index !== 0 && slides[index - 1];
  }

  if (direction === SlideDirection.Right) {
    return index !== slides.length - 1 && slides[index + 1];
  }

  return false;
};

/* TODO: плагин для еслинта для слайса */
const fileViewerSlice = createSlice({
  name: NAME,
  initialState,
  reducers: {
    show: (state) => {
      state.isVisible = true;
    },

    hide: (state) => {
      state.isVisible = false;
    },

    showLoader: (state) => {
      state.isLoading = true;
    },

    hideLoader: (state) => {
      state.isLoading = false;
    },

    showError: (state) => {
      state.isFailed = true;
    },

    hideError: (state) => {
      state.isFailed = false;
    },

    setFiles: (state, action: PayloadAction<Slide[]>) => {
      state.slides = action.payload;
    },

    slideTo: (state, action: PayloadAction<number>) => {
      const index = action.payload;
      if (index >= 0 && index < state.slides.length) {
        state.slideIndex = index;
      }
    },

    slideToLeft: (state) => {
      if (canSlide(state, SlideDirection.Left)) {
        const prevIndex = state.slideIndex;
        state.slideIndex = prevIndex - 1;
      }
    },

    slideToRight: (state) => {
      if (canSlide(state, SlideDirection.Right)) {
        const prevIndex = state.slideIndex;
        state.slideIndex = prevIndex + 1;
      }
    },
  },
});

export const { actions } = fileViewerSlice;
export const selectors = {
  getState: (state): FileViewerState => state[NAME],
  canSlide: (state, direction: SlideDirection): boolean => canSlide(state[NAME], direction),
};

export default fileViewerSlice.reducer;
