import { types as FileViewerTypes } from 'components/FileViewer';
import { ImageFile, DocviewerFile } from './types';
import getDownloadLink from './getDownloadLink';
import getDocviewerLink from './getDocviewerLink';

type Payload = (ImageFile | DocviewerFile) & {
  testMode?: boolean;
  stKey?: number | string;
};

type FileViewerAdapter = (payload: Payload) => FileViewerTypes.Slide;

const fileViewerAdapter: FileViewerAdapter = payload => {
  const file: FileViewerTypes.Slide = {
    type: payload.type,
    title: payload.name,
    id: payload.id,
    url: '',
    downloadUrl: getDownloadLink(payload),
  };

  if (payload.type === FileViewerTypes.FileType.Image) {
    file.url = getDownloadLink(payload);
  }

  if (payload.type === FileViewerTypes.FileType.Docviewer) {
    file.url = getDocviewerLink(payload);
  }

  return file;
};

export default fileViewerAdapter;
