import { DocviewerFile } from './types';

type Payload = DocviewerFile & {
  testMode?: boolean;
};

type GetDocviewerLink = (payload: Payload) => string;

const getDocviewerLink: GetDocviewerLink = payload =>
  payload.testMode
    ? `https://docviewer.tst.yandex-team.ru/?url=ya-crm://${payload.id}&name=${payload.urlName}`
    : `https://docviewer.yandex-team.ru/?url=ya-crm://${payload.id}&name=${payload.urlName}`;

export default getDocviewerLink;
