import { ImageFile, DocviewerFile } from './types';

type Payload = (ImageFile | DocviewerFile) & {
  stKey?: number | string;
};

type GetDownloadLink = (payload: Payload) => string;

const getDownloadLink: GetDownloadLink = payload => {
  if (payload.stKey) {
    return `${window.CRM_SPACE_API_HOST}/download/startrek/${payload.stKey}/files/${payload.id}/${
      payload.urlName
    }`;
  }

  return `${window.CRM_SPACE_API_HOST}/download/file/${payload.id}/${payload.urlName}`;
};

export default getDownloadLink;
