import { types as FileViewerTypes } from 'components/FileViewer';

interface BaseFile {
  id: number;
  name: string;
  size: string;
  type: FileViewerTypes.FileType;
  urlName: string;
}

export interface DocviewerFile extends BaseFile {
  dvId: string;
  type: FileViewerTypes.FileType.Docviewer;
}

export interface ImageFile extends BaseFile {
  type: FileViewerTypes.FileType.Image;
}

export type File = ImageFile | DocviewerFile;
