import React from 'react';
import createLink from 'modules/issues/utils/createLink';
import { TRANSLATE, MAIL_TYPES_TRANSLATE } from 'constants/backendTypes';
import css from '../style.modules.scss';
import { IssueItem } from './IssueHeader.types';

interface IssueHeaderProps {
  item: IssueItem;
}

const IssueHeader: React.FC<IssueHeaderProps> = (props) => {
  const { item } = props;
  const { parent, id, type } = item;
  const { issue, id: parentId } = parent;
  const { typeId, type: issueType } = issue;

  const direction = item.mailDirection ? ` (${MAIL_TYPES_TRANSLATE[item.mailDirection]})` : '';

  const parentLink = createLink({ id: parentId, typeId });
  const itemLink = `${parentLink}/${type}-${id}`;

  return (
    <span>
      <a className={css.link} href={parentLink} rel="noopener noreferrer" target="_blank">
        {`${issueType} ${parentId}`}
      </a>
      <a className={css.link} href={itemLink} rel="noopener noreferrer" target="_blank">
        {TRANSLATE[item.type] + direction}
      </a>
    </span>
  );
};

export default IssueHeader;
