/* eslint-disable react/sort-comp, react/prop-types, class-methods-use-this,   */

import React from 'react';
import { FormattedDate } from 'react-intl';
import { logger } from 'services/Logger';
import FilesList from 'components/FilesList';
import TYPES, { TRANSLATE, MAIL_TYPES_TRANSLATE } from 'constants/backendTypes';
import IssueHeader from './IssueHeader';
import css from './style.modules.scss';
import cssTable from './styleTable.modules.scss';

const renderDate = (text) => (
  <FormattedDate
    value={new Date(text)}
    year="numeric"
    month="numeric"
    day="numeric"
    hour="numeric"
    minute="numeric"
  />
);

export default class FilesTreeView extends React.Component {
  render() {
    const { files } = this.props;
    if (!files) {
      return null;
    }
    return <div className={css.mainContainer}>{this._renderTree(files)}</div>;
  }

  _renderLink(item) {
    /* todo:
     *   тут пока быстрая поддержка issue с обратной совместимостью
     *   бек сделает свою задачу, старый модуль закроем тогда можно чистить
     * */
    if (item.parent && item.parent.issue) {
      return <IssueHeader item={item} />;
    }

    let lowCaseType;
    const direction = item.mailDirection ? ` (${MAIL_TYPES_TRANSLATE[item.mailDirection]})` : '';
    if (item.type === TYPES.PERSONAL_MAIL) {
      lowCaseType = item.type.toLowerCase();
      return (
        <span>
          <a
            className={css.link}
            href={`#/mail/mailId/${item.id}`}
            rel="noopener noreferrer"
            target="_blank"
          >
            {`${TRANSLATE[item.type]} ${item.id}${direction}`}
          </a>
        </span>
      );
    }

    if (item.type === TYPES.MASSMAIL) {
      return (
        <span>
          <a
            className={css.link}
            href={`#/massmail/${item.id}`}
            rel="noopener noreferrer"
            target="_blank"
          >
            {`${TRANSLATE[item.type]} ${item.id}${direction}`}
          </a>
        </span>
      );
    }

    if (item.type === TYPES.ACCOUNT_COMMENT) {
      let accountId;
      try {
        accountId = item.parent.id;
      } catch (e) {
        logger.reportAppErrorOnly(new Error('FilesTreeView: Has no account id'));
      }

      return (
        <span>
          <a
            className={css.link}
            href={`#/account/${accountId}`}
            rel="noopener noreferrer"
            target="_blank"
          >
            {TRANSLATE[item.type]}
          </a>
        </span>
      );
    }

    if (item.type === TYPES.TICKET || item.type === TYPES.REQUEST) {
      lowCaseType = item.type.toLowerCase();
      return (
        <span>
          <a
            className={css.link}
            href={`#/${lowCaseType}/${item.id}`}
            rel="noopener noreferrer"
            target="_blank"
          >
            {`${TRANSLATE[item.type]} ${item.number}`}
          </a>
        </span>
      );
    }

    if (item.type === TYPES.MAIL || item.type === TYPES.MESSAGE || item.type === TYPES.NOTE) {
      if (item.parent) {
        lowCaseType = item.parent.type.toLowerCase();
        return (
          <span>
            <a
              className={css.link}
              href={`#/${lowCaseType}/${item.parent.id}`}
              rel="noopener noreferrer"
              target="_blank"
            >
              {`${TRANSLATE[item.parent.type]} ${item.parent.number}`}
            </a>
            <a
              className={css.link}
              href={`#/${item.parent.type.toLowerCase()}/${item.parent.id}/${item.timelineId}`}
              rel="noopener noreferrer"
              target="_blank"
            >
              {TRANSLATE[item.type] + direction}
            </a>
          </span>
        );
      }
      return <span className={css.type}>{TRANSLATE[item.type] + direction}</span>;
    }

    return null;
  }

  _renderTree(items) {
    return items.map((item) => this._renderTableItem(item));
  }

  _renderTableItem(item) {
    return (
      <div className={cssTable.item} key={item.type + item.id}>
        <div className={cssTable.header}>
          <div className={cssTable.date}>{renderDate(item.date)}</div>
          <div className={cssTable.linkBlock}>{this._renderLink(item)}</div>
        </div>
        {item.files ? (
          <div className={cssTable.filesContainer}>
            <FilesList files={item.files} isFullName view="link" />
          </div>
        ) : null}
      </div>
    );
  }
}
