import React from 'react';
import { useFormState } from 'react-final-form';

interface ConditionProps {
  when: string;
  is: any;
  children: React.ReactNode | ((value: any) => React.ReactNode);
}

const match = (is, value) => {
  let visible = false;

  if (typeof is === 'function') {
    visible = is(value);
  } else {
    visible = value === is;
  }

  return visible;
};

const render = ({ is, children }: ConditionProps, value: any) => {
  if (!match(is, value)) {
    return null;
  }

  if (typeof children === 'function') {
    return children(value);
  }

  return children;
};

export const Condition = (props: ConditionProps) => {
  const { when } = props;

  /*
   * переделал на useFormState, так как с Field не работает нормально destroyOnUnregister.
   * тут хуже производительность получается, так как реагирует на изменение любого поля.
   * Нужно что-то типо FormSpy только FieldSpy.
   * */
  const formState = useFormState({ subscription: { values: true } });
  const fieldValue = formState.values[when];

  return render(props, fieldValue);
};

export default Condition;
