import React from 'react';
import { FormikErrors } from 'formik';
import { storiesOf } from '@storybook/react';
import Button from '@crm/components/dist/lego2/Button';
import { ModalForm, ModalContainer, ModalFormProps } from 'lego/utils/modalForm';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import { FieldRow } from './FieldRow';
import { Theme } from './Row';
import { Form } from './Form';

interface FormValues {
  email: string;
}

interface FormProps extends ModalFormProps {
  size?: LegoSizeProp;
  theme?: Theme;
}

const getKey = (item) => item.id;

const provider = () => [
  {
    id: 1,
    name: '1_longnamelongnamelongnamelongnamelongname',
  },
  {
    id: 2,
    name: '2_longnamelongnamelongnamelongnamelongname',
  },
  {
    id: 3,
    name: '3_longnamelongnamelongnamelongnamelongname',
  },
];

const intialValues = { email: '', password: '' };
const validate = (values) => {
  const errors: FormikErrors<FormValues> = {};
  if (!values.email) {
    errors.email = 'Required';
  } else if (!/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i.test(values.email)) {
    errors.email = 'Invalid email address';
  }
  return errors;
};

const handleSubmitForm = (values) => {
  // eslint-disable-next-line no-console
  console.log(JSON.stringify(values, null, 2));
};

const BasicForm: React.FC<FormProps> = ({ size = 'm', theme, onSubmitSuccess, onCancel }) => (
  <Form
    initialValues={intialValues}
    validate={validate}
    onSubmit={handleSubmitForm}
    title="Basic form"
    onCancel={onCancel}
    onSubmitSuccess={onSubmitSuccess}
    size={size}
  >
    <FieldRow name="email" component="TextInput" label="email" size={size} theme={theme} />
    <FieldRow
      name="password"
      component="TextInput"
      label="password"
      size={size}
      theme={theme}
      optional
    />
    <FieldRow
      name="date"
      component="DateTimePicker"
      label="date"
      size={size}
      theme={theme}
      inputProps={{ time: true }}
    />
    <FieldRow name="text" component="TextArea" label="text" size={size} theme={theme} width="max" />
    <FieldRow
      name="suggest"
      component="Suggest"
      label="suggest"
      size={size}
      theme={theme}
      inputProps={{
        provider,
        getKey,
      }}
      width="max"
    />
    <FieldRow
      name="CheckBox"
      component="CheckBox"
      label="CheckBox"
      size={size}
      theme={theme}
      optional
      inputProps={{
        lineHeightSize: size,
      }}
    />
    <FieldRow
      name="select"
      component="Select"
      label="type"
      size={size}
      theme={theme}
      inputProps={{
        options: [
          {
            value: '1',
            content: '1_longnamelongnamelongnamelongnamelongname',
          },
          {
            value: '2',
            content: '2_longnamelongnamelongnamelongnamelongname',
          },
        ],
      }}
    />
  </Form>
);

storiesOf('FinalForm', module).add('form', () => (
  <div>
    <BasicForm size="m" />
  </div>
));

storiesOf('FinalForm', module).add('form with column', () => (
  <div>
    <BasicForm size="m" theme={Theme.Column} />
  </div>
));

const modal = new ModalForm('BasicForm', BasicForm, { size: 'small' });

const handleOpenModal = () => {
  modal.open({});
};

storiesOf('FinalForm', module).add('in modal', () => (
  <div>
    <Button onClick={handleOpenModal}>Open form</Button>
    <ModalContainer />
  </div>
));
