import { createContext, useContext } from 'react';
import { AnyObject } from 'react-final-form';

export interface ChangedField {
  name: string;
  value: AnyObject;
}

export interface FormContextProps {
  onChange: (field: ChangedField) => void;
}

export const FormContext = createContext<FormContextProps>({
  onChange: () => {},
});

export const Provider = FormContext.Provider;
export const Consumer = FormContext.Consumer;
export const useFormContext = () => useContext(FormContext);
