import React from 'react';
import { screen, render, act, fireEvent } from '@testing-library/react';
import { Form } from './Form';

describe('FinalForm/Form', () => {
  it('blocks save button by pending request', async () => {
    const mockSubmit = jest.fn(() => Promise.resolve());

    await act(async () => {
      render(<Form onSubmit={mockSubmit} />);
    });

    const saveButton = screen.getByRole('button', { name: 'Сохранить' });

    await act(async () => {
      fireEvent.click(saveButton);
      fireEvent.click(saveButton);
    });

    expect(mockSubmit).toBeCalledTimes(1);
  });
});
