import React from 'react';
import Label from 'lego/components/Label';
import cx from 'classnames';
import css from './Row.module.css';
import { DEFAULT_INPUT_SIZE } from '../constants';
import { RowProps, Theme } from './Row.types';

export const Row: React.FC<RowProps> = (props) => {
  const {
    className,
    size = DEFAULT_INPUT_SIZE,
    label,
    required,
    optional,
    theme = Theme.Row,
    width,
    SelectFieldComponent,
    children,
    hasLine = true,
    labelColor,
  } = props;

  return (
    <div className={cx(css.b, className, css[`b_theme_${theme}`])}>
      {SelectFieldComponent && <SelectFieldComponent />}
      {label && (
        <Label
          className={css.b__label}
          size={size}
          required={required}
          optional={optional}
          hasLine={hasLine && theme === Theme.Row}
          color={labelColor}
        >
          {label}
        </Label>
      )}
      <div className={cx(css.b__fieldWrap, css[`b__fieldWrap_width_${width}`])}>{children}</div>
    </div>
  );
};

export default Row;
