import React, { ComponentType, useState } from 'react';
import { FormProps } from 'react-final-form';
import { Form } from 'react-final-form';
import { composeValidators } from './withLoadingMutator.utils';

export const withLoadingMutator = <Props extends FormProps>(
  WrappedComponent: ComponentType<Props>,
) => (props: Props) => {
  const { subscription, mutators, validate } = props;

  const [isLoading, setLoading] = useState(false);

  const validateLoading = () => {
    const error: { [key: string]: string | boolean } = {};

    if (isLoading) {
      error.loading = true;
    }

    return error;
  };

  return (
    <WrappedComponent
      {...props}
      subscription={{ ...subscription, errors: true }}
      mutators={{
        ...mutators,
        setLoading: (args) => {
          setLoading(args[0]);
        },
      }}
      validate={composeValidators(validateLoading, validate)}
    />
  );
};

export const FormWithLoading = withLoadingMutator(Form);
