import * as React from 'react';
import { MergeRef } from 'utils/mergeRef';
import { FormApi } from 'final-form';
import { forceChangeLocationFlag, ForceChangeLocationFlag } from 'services/ForceChangeLocationFlag';
import { WithLocationChangeAutoSaveProps } from './withLocationChangeAutoSave.types';

export const createWithLocationChangeAutoSave = (
  forceChangeLocationFlag: ForceChangeLocationFlag,
) => {
  return <FormValues, T extends WithLocationChangeAutoSaveProps<FormValues>>(
    WrappedComponent: React.ComponentType<T>,
  ) => {
    class WithLocationChangeAutoSave extends React.Component<T> {
      static defaultProps = {
        useLocationChangeAutoSave: false,
      };

      private formApiRef = new MergeRef<FormApi<FormValues>>();

      public componentWillUnmount() {
        if (!(this.props.useLocationChangeAutoSave && forceChangeLocationFlag.current)) {
          return;
        }

        const formState = this.formApiRef.current!.getState();

        if (formState.pristine) {
          return;
        }

        this.props.onSubmit(formState.values, this.formApiRef.current!);
      }

      public render() {
        const { formApiRef } = this.props;

        this.formApiRef.refs = [formApiRef];

        return <WrappedComponent {...this.props} formApiRef={this.formApiRef} />;
      }
    }

    return WithLocationChangeAutoSave;
  };
};

export const withLocationChangeAutoSave = createWithLocationChangeAutoSave(forceChangeLocationFlag);
