import * as React from 'react';
import { FormSpy, FormSpyRenderProps } from 'react-final-form';
import Prompt from 'components/Prompt';
import { WithPreventUnloadProps } from './withPreventUnload.types';

export const withPreventUnload = <T extends WithPreventUnloadProps & { innerRef?: React.Ref<T> }>(
  WrappedComponent: React.ComponentType<T>,
) => {
  class WithPreventUnload extends React.Component<T> {
    static defaultProps = {
      isPreventUnload: false,
      preventCloseBrowser: true,
    };

    private currentPristine: boolean = false;

    private renderSpy = ({ pristine }: FormSpyRenderProps) => {
      const { isPreventUnload, preventCloseBrowser, preventChangeLocation } = this.props;
      this.updatePristineIfNeeded(pristine);
      return (
        <Prompt
          when={isPreventUnload && !pristine}
          preventCloseBrowser={preventCloseBrowser}
          preventChangeLocation={preventChangeLocation}
        />
      );
    };

    private updatePristineIfNeeded(pristine: boolean) {
      if (this.currentPristine !== pristine) {
        this.currentPristine = pristine;
        this.notifyChangePristine(pristine);
      }
    }

    private notifyChangePristine(pristine: boolean) {
      if (this.props.onChangePristine) {
        this.props.onChangePristine(pristine);
      }
    }

    private formSpy = (<FormSpy subscription={{ pristine: true }}>{this.renderSpy}</FormSpy>);

    public render() {
      return (
        <WrappedComponent
          {...this.props}
          ref={this.props.innerRef}
          addonBefore={
            <>
              {this.formSpy}
              {this.props.addonBefore}
            </>
          }
        />
      );
    }
  }

  return WithPreventUnload;
};
