import * as React from 'react';
import {
  withSaveValues,
  WrappedComponentProps,
  OuterWrappedComponentProps,
} from './withSaveValues';

interface Options {
  localStorageKey: string;
}

const getLocalStorageKey = (rawKey: string): string => {
  const prefix = 'space.formSavedValues';
  return `${prefix}.${rawKey}`;
};

/**
 * Hoc для сохранения значений формы в localStorage
 */
export const withSave2LocalStorage = <TValues extends {}>(options: Options) => <
  TProps extends WrappedComponentProps<TValues>
>(
  WrappedComponent: React.ComponentType<TProps>,
): React.ComponentClass<TProps & OuterWrappedComponentProps> =>
  withSaveValues<TValues>({
    onValuesSave: (values) => {
      const json = JSON.stringify(values);
      localStorage.setItem(getLocalStorageKey(options.localStorageKey), json);
    },
    getSavedValues: () => {
      const json = localStorage.getItem(getLocalStorageKey(options.localStorageKey));
      try {
        return JSON.parse(json as string);
      } catch {
        return null;
      }
    },
  })(WrappedComponent);
