import React, { PureComponent, ReactNode } from 'react';
import css from './Finance.module.css';
import TabsPanel from './TabsPanel';
import FinanceBlock from './FinanceBlock';

import { FinanceBlock as FinanceBlockType, FinanceProps, FinanceState } from './Finance.types';

export default class Finance extends PureComponent<FinanceProps, FinanceState> {
  public constructor(props: FinanceProps) {
    super(props);

    const empty = {
      tabs: [{}],
    };
    this.state = {
      activeTabNameInFinanceSources: (props.financeData.finance[0] || empty).name,
      activeTabNameInFinanceBlocks: (props.financeData.finance[0] || empty).tabs[0].name,
    };
  }

  private getFirstTabFromFinanceSources = (name: string): string => {
    const block = this.props.financeData.finance.find((block): boolean => block.name === name);
    if (block) {
      return block.tabs[0].name;
    }
    return '';
  };

  private changeActiveTabInFinanceSources = (value: string): void => {
    this.setState({
      activeTabNameInFinanceSources: value,
      activeTabNameInFinanceBlocks: this.getFirstTabFromFinanceSources(value),
    });
  };

  private changeActiveTabInFinanceBlock = (value: string): void => {
    this.setState({
      activeTabNameInFinanceBlocks: value,
    });
  };

  private getActiveFinanceSource = (): FinanceBlockType | undefined => {
    const { activeTabNameInFinanceSources } = this.state;
    return this.props.financeData.finance.find(
      (block): boolean => block.name === activeTabNameInFinanceSources,
    );
  };

  public render(): ReactNode {
    const { activeTabNameInFinanceSources, activeTabNameInFinanceBlocks } = this.state;
    const activeSource = this.getActiveFinanceSource();
    const { tabsView = 'vertical', title } = this.props;
    return (
      <div className={css.b}>
        <TabsPanel
          title={title}
          collection={this.props.financeData.finance}
          activeTabName={activeTabNameInFinanceSources}
          changeTab={this.changeActiveTabInFinanceSources}
        />
        <div className={css['b__view-container']}>
          {activeSource && (
            <FinanceBlock
              tabsView={tabsView}
              changeTab={this.changeActiveTabInFinanceBlock}
              financeSource={activeSource}
              activeTabName={activeTabNameInFinanceBlocks}
            />
          )}
        </div>
      </div>
    );
  }
}
