import { Table } from '../Table/Table.types';

export type TabsView = 'horizontal' | 'vertical';

export interface FinanceProps {
  financeData: FinanceData;
  tabsView?: TabsView;
  title?: string;
}

export interface FinanceState {
  activeTabNameInFinanceSources: string;
  activeTabNameInFinanceBlocks: string;
}

export interface FinanceData {
  // sysDates: any; // account.sysDates
  finance: FinanceBlock[];
}

export interface FinanceBlock {
  name: string; // уникальный ключ в массиве
  title: string; // название, которое нарисуется пользователю
  tabs: FinanceTable[];
}

export interface Chart {
  name: string;
  labels: string[];
  lines: {
    code: string;
    name: string;
    offset: number;
    points: number[];
  }[];
}

export interface Charts {
  growth: Chart;
  shipments: Chart;
}

export interface FinanceTable {
  name: string; // уникальный ключ в массиве
  title: string; // название, которое нарисуется пользователю
  table?: Table; // большой json описание таблицы, который фронт будет рисовать
  charts?: Charts; // на каждом табе может быть график
}
