import {
  TableTwoColumn,
  TableOneColumn,
  TableData,
} from '../../Table/Table.examples/Table.examples.config';

const generateRandowChart = () => ({
  name: `Chart-${Math.floor(Math.random() * 1000)}`,
  labels: Array(10)
    .fill(true)
    .map((item, index) => {
      return `${index + 1}-08-2020`.padStart(10, '0');
    }),
  lines: Array(2)
    .fill(true)
    .map((item, index) => {
      return {
        code: `testCode-${index}`,
        name: `testName-${index}`,
        offset: 0,
        points: Array(20)
          .fill(true)
          .map(() => Math.floor(Math.random() * 100)),
      };
    }),
});

const chart1 = {
  growth: generateRandowChart(),
  shipments: generateRandowChart(),
};

export const financeBlock = {
  name: 'Finance Block Title',
  title: 'Finance Block Title',
  tabs: [
    { name: 'tab1', title: 'Table 1 cols', table: TableOneColumn },
    { name: 'tab2', title: 'Table 2 cols', table: TableTwoColumn },
    { name: 'tab3', title: 'Table 20 cols', table: TableData },
    { name: 'chart1', title: 'Charts', charts: chart1 },
    { name: 'chartAndTable', title: 'Charts and Table', table: TableTwoColumn, charts: chart1 },
  ],
};

export const financeBlock2 = {
  name: 'Finance Block Title 2',
  title: 'Finance Block Title 2',
  tabs: [
    { name: 'tab1', title: 'Table 2', table: TableTwoColumn },
    { name: 'tab2', title: 'Table 1', table: TableOneColumn },
    { name: 'tab3', title: 'Big Table', table: TableData },
    { name: 'chart1', title: 'Charts', charts: chart1 },
    { name: 'chartAndTable', title: 'Charts and Table', table: TableTwoColumn, charts: chart1 },
  ],
};

export const finance = {
  finance: [financeBlock, financeBlock2],
};
