import React, { PureComponent, ReactNode, ComponentType } from 'react';
import Charts from 'pages/accounts/modules/info/modules/charts/components/Charts';
import cx from 'classnames';
import css from './FinanceBlock.module.css';
import Table from '../../Table';
import TabsPanel, { VerticalTabsPanel } from '../TabsPanel';
import { FinanceBlockProps } from './FinanceBlock.types';
import { TabsPanelProps } from '../TabsPanel/TabsPanel.types';
import { TabsView } from '../Finance.types';

const tabsPanelsCollection: Record<TabsView, ComponentType<TabsPanelProps>> = {
  vertical: VerticalTabsPanel,
  horizontal: TabsPanel,
};

export default class FinanceBlock extends PureComponent<FinanceBlockProps> {
  private renderTabsPanel = (tabPanelProps: TabsPanelProps) => {
    const { tabsView } = this.props;
    const Panel = tabsPanelsCollection[tabsView] || VerticalTabsPanel;
    return <Panel {...tabPanelProps} />;
  };

  public render(): ReactNode {
    const {
      financeSource: { tabs },
      activeTabName,
      changeTab,
      tabsView,
    } = this.props;
    const tabPanelProps = { activeTabName, changeTab, collection: tabs };

    const tabData = tabs.find((tab): boolean => tab.name === activeTabName);
    return (
      <div
        className={cx(css.b, {
          [css.b_tabsView_vertical]: tabsView === 'vertical',
          [css.b_tabsView_horizontal]: tabsView === 'horizontal',
        })}
      >
        {this.renderTabsPanel(tabPanelProps)}
        <div className={css['b__view-container']}>
          <div className={css.b__section}>
            {tabData && tabData.table && <Table tableData={tabData.table} />}
            {tabData && tabData.charts && (
              <div className={css.b__chartsContainer}>
                <Charts key={tabData.name} charts={tabData.charts} />
              </div>
            )}
          </div>
        </div>
      </div>
    );
  }
}
