import React, { PureComponent } from 'react';

import BlockToolbar from 'pages/accounts/modules/info/components/BlockToolbar';
import { TabsPanelProps } from './TabsPanel.types';
import css from './TabsPanel.module.css';

export default class FinanceBlock extends PureComponent<TabsPanelProps> {
  private getTabs = (): { NAME: string; TITLE: string }[] =>
    this.props.collection.map((tab) => ({ NAME: tab.name, TITLE: tab.title }));

  public render() {
    const { activeTabName, changeTab, title } = this.props;
    const tabs = this.getTabs();

    return (
      <div className={css.b}>
        {title && <span className={css.b__title}>{title}</span>}
        <BlockToolbar tabs={tabs} activeTab={activeTabName} onTabChange={changeTab} />
      </div>
    );
  }
}
