import React, { PureComponent } from 'react';

import Button from '@crm/components/dist/lego2/Button';
import css from './Tab.module.css';
import { TabProps } from './Tab.types';

export default class Tab extends PureComponent<TabProps> {
  private changeTab = () => {
    this.props.changeTab(this.props.tab.name);
  };

  public render() {
    const { activeTabName, tab } = this.props;

    return (
      <div className={css.b}>
        <Button
          size="xs"
          // @ts-ignore
          pin="round-round"
          width="max"
          view={activeTabName !== tab.name ? 'pseudo' : 'default'}
          onClick={this.changeTab}
        >
          {tab.title}
        </Button>
      </div>
    );
  }
}
