import React, { PureComponent } from 'react';

import { TabsPanelProps } from '../TabsPanel.types';
import css from './VerticalTabsPanel.module.css';
import Tab from './Tab';

export default class VerticalTabsPanel extends PureComponent<TabsPanelProps> {
  public render() {
    const { activeTabName, collection, changeTab } = this.props;

    return (
      <div className={css.b}>
        {collection.map((tab) => (
          <Tab key={tab.name} tab={tab} activeTabName={activeTabName} changeTab={changeTab} />
        ))}
      </div>
    );
  }
}
