import React from 'react';
import cx from 'classnames';
import css from './styles.modules.scss';

const FinanceTableCompact = props => {
  const { className, data, values, valuesToDisplay } = props;
  const keys = valuesToDisplay || Object.keys(values);

  return (
    <div className={cx(className, css.root)}>
      <table className={css.data}>
        {keys.map(value => {
          const item = values[value];
          const result = data[value];

          return result || result === 0 ? (
            <tr className={css.row}>
              <td className={cx(css.item, css.item_header)}>{item.title}</td>
              <td className={css.item}>{item.format(result)}</td>
            </tr>
          ) : null;
        })}
      </table>
    </div>
  );
};

FinanceTableCompact.defaultProps = {
  data: {},
  values: {},
};

export default FinanceTableCompact;
