import React from 'react';
import cx from 'classnames';
import css from './styles.modules.scss';

const renderCell = ({ type, item, value, headerItemWidth }) => {
  switch (type) {
    case 'header':
      return (
        <td className={cx(css.item, css.item_header)}>
          <span style={headerItemWidth && { maxWidth: headerItemWidth }}>{item.title}</span>
        </td>
      );
    case 'cell':
      return <td className={css.item}>{item.format(value)}</td>;
  }
};

const FinanceTable = props => {
  const {
    className,
    title,
    data,
    values,
    valuesToDisplay,
    leftColWidth,
    leftColMinWidth,
    headerItemWidth,
  } = props;
  const keys = valuesToDisplay || Object.keys(values);
  const leftColStyle = {};

  if (leftColWidth) {
    leftColStyle.width = leftColWidth;
  }
  if (leftColMinWidth) {
    leftColStyle.minWidth = leftColMinWidth;
  }

  return (
    <table className={cx(className, css.root)}>
      <tr className={css.header}>
        <td className={cx(css.item, css.item_title)} style={leftColStyle}>
          {title}
        </td>
        {keys.map(key =>
          renderCell({
            type: 'header',
            item: values[key],
            headerItemWidth,
          }),
        )}
      </tr>
      {data.map(row =>
        row.name ? (
          <tr className={css.row}>
            <td className={cx(css.item, css.item_header)}>{row.name}</td>
            {keys.map(key =>
              renderCell({
                type: 'cell',
                item: values[key],
                value: row[key],
              }),
            )}
          </tr>
        ) : null,
      )}
    </table>
  );
};

export default FinanceTable;
