import React from 'react';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './FloatContainer.module.css';
import { FloatContainerProps } from './FloatContainer.types';

export const FloatContainer = (props: FloatContainerProps) => {
  const {
    onToggle,
    show = true,
    children,
    keepMount = true,
    className,
    classNameContent,
    innerRef,
  } = props;

  const renderButton = () => {
    if (show) {
      return null;
    }

    return (
      <div className={cx(css.FloatContainer__buttonContainer, className)}>
        <Button
          view="action"
          size="l"
          pin="circle-circle"
          onClick={onToggle}
          icon={(cls) => <Icon className={cls} svg="writeEdit" />}
        />
      </div>
    );
  };

  const renderContent = () => {
    if (!keepMount && !show) {
      return null;
    }

    return (
      <div
        className={cx(css.FloatContainer, className, classNameContent)}
        hidden={!show}
        ref={innerRef}
      >
        {children({
          toggle: (
            <Button
              onClick={onToggle}
              view="clear"
              icon={(cls) => <Icon className={cls} svg="exitFullscreen" />}
            />
          ),
        })}
      </div>
    );
  };

  return (
    <>
      {renderContent()}
      {renderButton()}
    </>
  );
};
