import { ReactNode, Ref } from 'react';

export interface RenderContentProps {
  toggle: ReactNode;
}

export interface FloatContainerProps {
  show?: boolean;
  onToggle?: () => void;
  children: (props: RenderContentProps) => ReactNode;
  keepMount?: boolean;
  className?: string;
  classNameContent?: string;
  innerRef?: Ref<HTMLDivElement>;
}

export interface FloatContainerStatefulProps
  extends Omit<FloatContainerProps, 'onToggle' | 'show'> {
  defaultShow?: boolean;
}
