import React, { useState } from 'react';
import { FloatContainer } from './FloatContainer';
import { FloatContainerStatefulProps } from './FloatContainer.types';

export const FloatContainerStateful = ({
  defaultShow = false,
  ...props
}: FloatContainerStatefulProps) => {
  const [show, setShow] = useState(defaultShow);

  return <FloatContainer show={show} onToggle={() => setShow(!show)} {...props} />;
};
